<?php

namespace App\Http\Controllers;

use Stripe\Stripe;
use Illuminate\Http\Request;
use Stripe\PaymentIntent;

class Generaficha extends Controller
{
    public function generarFicha(Request $request)
    {
        $name = $request->input('name');
        $email = $request->input('email');
        $phone = $request->input('phone');
        $price = $request->input('price');
        if($name == null || $email == null || $phone == null || $price == null){
            return response()->json(['error' => 'Faltan datos'], 400);
        }else{ 
            // Configura tu clave secreta de Stripe
            $stripe = new \Stripe\StripeClient('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');
           //TRANSFERENCIA CON FACTURAS
            // Crear un cliente
            $customer = $stripe->customers->create([
                'name' =>  $name,
                'email' => $email,
                'phone' =>  $phone,
                //'price' =>  $price,
            ]);

            $customerId = $customer->id;
            $stripe->invoiceItems->create([
                'amount' => $price,
                'currency' => 'mxn',
                'customer' =>  $customerId,
                'description' => 'Aprende Bienes Raíces Desde Cero',
            ]);
    
            $invoices = $stripe->invoices->create([
                'customer' => $customerId,
                'payment_settings'=> ['payment_method_types' => ['customer_balance']],
                'collection_method' => 'send_invoice',
                'auto_advance' => true, // Habilitar cobro automático
                'days_until_due' => 30,
            ]);
    
            $stripe->invoices->finalizeInvoice($invoices->id, []);
            
            
           $linkPago =  $stripe->invoices->retrieve($invoices->id);
            
            return response()->json(['message' => 'Ficha generada :)', 'name' => $name, 'email' => $email, 'phone' => $phone, 'id_fact'=>$invoices->id, 'price' => $price, 'url_pago' => $linkPago->hosted_invoice_url], 200);
        }
        
    }
}
