<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, user-scalable=no, initial-scale=1.0, maximum-scale=1.0, minimum-scale=1.0">
   <link rel="stylesheet" href="{{ route('style.css') }}">
    <link rel="stylesheet" href="{{ route('alertify.css') }}">
    <!-- <link rel="stylesheet" href="{{asset('alertifyjs/css/alertify.css')}}"> -->
    <link rel="shortcut icon" href="{{ route('logo.png') }}" type="image/x-icon" />
    <title>Creadores de Exito | Formulario</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <script src="https://js.stripe.com/v3/"></script>
    <!-- <script src="{{asset('alertifyjs/alertify.js')}}"></script> -->
 <script src="{{ route('alertify.js') }}"></script>
    <!-- Styles -->
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.4.1/css/bootstrap.min.css" integrity="sha384-Vkoo8x4CGsO3+Hhxv8T/Q5PaXtkKtu6ug5TOeNV6gBiFeWPGFN9MuhOf23Q9Ifjh" crossorigin="anonymous">
    <style>
        * {
            font-family: "Helvetica Neue", Helvetica;
            font-size: 15px;
            font-variant: normal;
            padding: 0px 0px 4px;
            margin: 0;
        }

        html {
            height: 100%;
            width: 100%;
        }

        body {
            background: white;
        }

        form {
            width: 480px;
            margin: 20px 0;
        }

        .group {
            background: white;
            box-shadow: 0 7px 14px 0 rgba(49, 49, 93, 0.10),
            0 3px 6px 0 rgba(0, 0, 0, 0.08);
            border-radius: 4px;
            margin-bottom: 20px;
        }

        label {
            position: relative;
            color: #8898AA;
            font-weight: 300;
            height: 40px;
            line-height: 40px;
            margin-left: 20px;
            display: flex;
            flex-direction: row;
        }

        .group label:not(:last-child) {
            border-bottom: 1px solid #F0F5FA;
        }

        label > span {
            width: 120px;
            text-align: left;
            margin-right: 30px;
        }

        .field {
            background: transparent;
            font-weight: 300;
            border: 0;
            color: #31325F;
            outline: none;
            flex: 1;
            padding-right: 10px;
            padding-left: 10px;
            cursor: text;
        }

        .field::-webkit-input-placeholder {
            color: #CFD7E0;
        }

        .field::-moz-placeholder {
            color: #CFD7E0;
        }

        button {
            float: left;
            display: block;
            background: #876a3e;
            color: white;
            box-shadow: 0 7px 14px 0 rgba(49, 49, 93, 0.10),
            0 3px 6px 0 rgba(0, 0, 0, 0.08);
            border-radius: 4px;
            border: 0;
            margin-top: 20px;
            font-size: 15px;
            font-weight: 400;
            width: 100%;
            height: 40px;
            line-height: 38px;
            outline: none;
        }

        button:focus {
            background: #2c3950;
        }

        button:active {
            background: #a78347;
        }

        .outcome {
            float: left;
            width: 100%;
            padding-top: 8px;
            min-height: 24px;
            text-align: center;
        }

        .success, .error {
            display: none;
            font-size: 13px;
        }

        .success.visible, .error.visible {
            display: inline;
        }

        .error {
            color: #E4584C;
        }

        .success {
            color: #666EE8;
        }

        .success .token {
            font-weight: 500;
            font-size: 13px;
        }
        
        .tarjeta {
            height:75px !important;
            
        }
        }

    </style>


</head>
<body>
    <header class="blog-header" style="background-color: #6a1b20;">
        <div class="row flex-nowrap justify-content-between align-items-center">
            <div class="col-4 pt-1"></div>
            <div class="col-4 pt-1 text-center flex-nowrap justify-content-between align-items-center">
                <img class="img-responsive standard-logo retina-logo" src="{{ route('logo.png') }}" alt="Creadores de Éxitos" width="111">
            </div>
            <div class="col-4 d-flex justify-content-end align-items-center"></div>
        </div>
    </header>
    <div class="container">
        <div class="content">
            <div class="row justify-content-center align-items-center mt-3">
                <div id="details">
                <h6 class="col-sm-6 col-md-12" style="font-family: 'Helvetica Neue', Helvetica;">Ingresa tu tarjeta para verificar si tu pago está disponible a meses sin intereses.</h6><br>
                    <form id="payment-form" class="col-sm-12">
                        @csrf
                        <div class="group">
                            <label>
                                <span>Nombre</span>
                                <input id="cardholder-name" name="cardholder-name" class="field" placeholder="Nombre Completo" required />
                            </label>
                            <label>
                                <span>Teléfono</span>
                                <input id="phone" class="field" placeholder="Número de teléfono" type="number" maxlength="10" oninput="if(this.value.length > this.maxLength) this.value = this.value.slice(0, this.maxLength);" required />
                            </label>
                            <label>
                                <span>Correo</span>
                                <input id="email" class="field" placeholder="Dirección de correo electrónico" type="email" required />
                            </label>
                        </div>

                        <div class="group tarjeta">
                            <label>
                                <span>Tarjeta de Crédito </span>
                                <div id="card-element" class="field"></div>
                            </label>
                        </div>
                   
                         <div class="row justify-content-center align-items-center" id="cont-summary">
                        <div class="col-md-5 col-lg-12 order-md-last">
                          <h4 class="d-flex justify-content-between align-items-center mb-3">
                            {{-- <span class="text-primary">Your cart</span> --}}
                          </h4>
                          <ul class="list-group mb-3">
                            <li class="list-group-item d-flex justify-content-between lh-sm">
                              <div>
                                <h6 class="my-0" id="product-name"></h6>
                                <small class="text-muted">Producto</small>
                              </div>
                               
                               <!-- USD -->
                                <!-- <div id="product-selection" class="group" style="display:none;">   
                                    <input type="checkbox" name="currency" value="MXN" checked onchange="checkboxChanged(this)">
                                         MXN        
                                    <input type="checkbox" name="currency" value="USD" onchange="checkboxChanged(this)">
                                     USD
                                      
                                </div>                               -->
                              
                              
                              
                              
                              <span class="text-muted" id="mounth"></span>
                            </li>
                          </ul>
                        </div>
                    </div>
                        
                        
                
                        <button id="card-button">Ver Planes de Pago</button>
                        <button class="btn btn-red loading" type="button" disabled hidden>
                            <span class="spinner-grow spinner-grow-sm" role="status" aria-hidden="true"></span>
                            <span class="sr-only">Loading...</span>
                          </button>
                    </form>
                </div>

                <div id="plans" hidden>
                    <form id="installment-plan-form" class="col-sm-12">
                    <h6 class="col-12" style="font-family: 'Helvetica Neue', Helvetica;">Selecciona una de las opciones disponibles</h6>

                        @csrf
                        <div class="container">
                            <label id="cardlabel"><input id="immediate-plan" type="radio" class="option-input radio" name="installment_plan" value="-1" />1 exhibición</label>
                            <input id="payment-intent-id" type="hidden" />
                        </div>
                    </form>
                    <button id="confirm-button">Confirmar Pago</button>
                    <button class="btn btn-dark loading" type="button" disabled hidden>
                        <span class="spinner-grow spinner-grow-sm" role="status" aria-hidden="true"></span>
                        <span class="sr-only">Loading...</span>
                      </button>
                </div>
                <div id="result" hidden>
                    <strong>
                        <p id="status-message"></p>
                    </strong>
                    <div class="progress">
                        <div class="progress-bar progress-bar-striped bg-success" role="progressbar" style="width: 100%" aria-valuenow="25" aria-valuemin="0" aria-valuemax="100"></div>
                    </div>
                    <button id="backtostart" onclick="reload()">Regresar</button>
                </div>
            </div>
            <div class="row justify-content-center align-items-center" id="cont-summary">
                <div class="col-md-5 col-lg-4 order-md-last">
                  <h4 class="d-flex justify-content-between align-items-center mb-3">
                    {{-- <span class="text-primary">Your cart</span> --}}
                  </h4>
                  <ul class="list-group mb-3">
                    <li class="list-group-item d-flex justify-content-between lh-sm">
                      <div>
                        <h6 class="my-0" id="product-name"></h6>
                        <small class="text-muted">                                                          </small>
                      </div>
                      <span class="text-muted" id="mounth"></span>
                    </li>
                  </ul>
                </div>
            </div
        </div>
    </div>
</body>
<script>
    const btnplans = document.getElementById('card-button');
    const btnconfim = document.getElementById('confirm-button');
    const btnloadingu = document.getElementsByClassName('loading')[0];
    const btnloadingd = document.getElementsByClassName('loading')[1];
    
    
    //var defaultMount = getparams().monto;
    //var mount = defaultMount;
    let defaultMount = getparams().monto;
    let mount = defaultMount;
    //const mount = getparams().monto;
    const referido = getparams().ref;
    const productname = getparams().product;
    const tags = getparams().tags;
    const utm_medium = getparams().utm_medium;
    const utm_source = getparams().utm_source;
    const cf_uvid = getparams().cf_uvid;
    const generacion = "Generacion" + " " + getparams().generacion;
    var stripe = Stripe('pk_live_SelhTTrsoEl8AazLFrLdbbvt');
    var elements = stripe.elements();
    var cardElement = elements.create('card', {
        style: {
            base: {
                iconColor: '#666EE8',
                color: '#31325F',
                lineHeight: '40px',
                fontWeight: 300,
                fontFamily: 'Roboto, Open Sans, Segoe UI, sans-serif',
                fontSize: '15px',

                '::placeholder': {
                    color: '#CFD7E0',
                },
            },
        }
    });
    cardElement.mount('#card-element');
    var cardholderName = document.getElementById('cardholder-name');
    var email=document.getElementById('email');
    var phone=document.getElementById('phone');
    var form = document.getElementById('payment-form');
    var tokencfsr = document.getElementsByName('_token')[0];
    var align = tokencfsr.getAttribute('content');
    form.addEventListener('submit', function (ev) {
        ev.preventDefault();
        btnplans.hidden=true;
        btnloadingu.hidden=false;
        document.getElementById('card-button').hidden=true;
        document.getElementsByClassName('loading').hidden=false;
        stripe.createPaymentMethod({
            type: 'card',
            card: cardElement,
            billing_details: {name: cardholderName.value, email:email.value, phone:phone.value}
        }).then(function (result) {
            if (result.error) {
                btnplans.hidden=false;
        btnloadingu.hidden=true;
                document.getElementById('card-button').hidden=false;
                document.getElementsByClassName('loading').hidden=true;
                alertify.set('notifier', 'position', 'botton-right');
                alertify.error('<strong style="color: white;">Ingrese los datos correctos de su tarjeta, por favor intente de nuevo.</strong>');
            } else {
                // Otherwise send paymentMethod.id to your server (see Step 2)
                fetch('{{ route('plans') }}', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                        "X-CSRF-TOKEN": align
                    },
                    body: JSON.stringify({payment_method_id: result.paymentMethod.id, _token: tokencfsr.value, mount: mount, product:productname,name:cardholderName.value, email:email.value, phone:phone.value, cp:result.paymentMethod.billing_details.address.postal_code})
                }).then(function (result) {
                    //REVISAR EDUARDO--
                    // Handle server response (see Step 3)
                    result.json().then(function (json) {
                        handleInstallmentPlans(json);
                    })
                });
            }
        });
    });
    const selectPlanForm = document.getElementById('installment-plan-form');
    let availablePlans = [];
    
    
    const handleInstallmentPlans = async (response) => {
        if (response.error) {
            btnplans.hidden=false;
        btnloadingu.hidden=true;
            alertify.set('notifier', 'position', 'botton-right');
            alertify.error('<strong style="color: white;">Error al comunicarse con el servidor, intente de nuevo.</strong>');
        } else {
            // Store the payment intent ID.
            document.getElementById('payment-intent-id').value = response.intent_id;
            
           
            //var informacionObjeto = JSON.stringify(response, null, 4);
            //if(mount == '5999'){
                
            //let objetoMSIMentoria = {
                    //"intent_id": response.intent
                //};
            /* let nuevosPlanes = [
                {
                    "count": 3,
                    "interval": "month",
                    "type": "fixed_count"
                },
                {
                    "count": 6,
                    "interval": "month",
                    "type": "fixed_count"
                },
                {
                    "count": 9,
                    "interval": "month",
                    "type": "fixed_count"
                },
                {
                    "count": 12,
                    "interval": "month",
                    "type": "fixed_count"
                }
            ];
            response.available_plans = nuevosPlanes;*/
            
           //  availablePlans = response.available_plans;
            //}
            //else{
                  availablePlans = response.available_plans;
            //}

        var informacionObjeto = JSON.stringify(response, null, 4);
            //alert(informacionObjeto);
            //alert(mount);
            let formatplans = getparams().plan.split(',');
            // Show available installment options
            availablePlans.forEach((plan, idx) => {
                if (plan.count == descript(formatplans[0]) || plan.count == descript(formatplans[1])|| plan.count == descript(formatplans[2]) || plan.count == descript(formatplans[3])) {
                    const newlabel = document.getElementById('cardlabel').cloneNode();
                    const newInput = document.getElementById('immediate-plan').cloneNode();
                    newInput.setAttribute('value', idx);
                    newInput.setAttribute('id', '');
                    const label = document.createElement('label');
                    label.appendChild(newInput);
                    label.appendChild(
                        document.createTextNode(`${plan.count} Meses`),
                        );
                    newlabel.appendChild(label);
                    selectPlanForm.appendChild(newlabel);   
                }
            });

            document.getElementById('details').hidden = true;
            document.getElementById('plans').hidden = false;
        }
    };



    const confirmButton = document.getElementById('confirm-button');

    confirmButton.addEventListener('click', async (ev) => {
        btnconfim.hidden=true;
        btnloadingd.hidden=false;
        const selectedPlanIdx = selectPlanForm.installment_plan.value;
        const selectedPlan = availablePlans[selectedPlanIdx];
        const name=document.getElementById('cardholder-name').value;
        const tel=document.getElementById('phone').value;
        const email=document.getElementById('email').value;
        const intentId = document.getElementById('payment-intent-id').value;
        const response = await fetch('{{ route('confirm') }}', {
            method: 'POST',
            headers: {'Content-Type': 'application/json', "X-CSRF-TOKEN": align},
            body: JSON.stringify({
                payment_intent_id: intentId,
                selected_plan: selectedPlan,
                _token: tokencfsr.value,
                mount:mount,
                name:name,
                email:email,
                phone:tel,
                ref:referido,
                productname:productname,
                tags:tags,
                utm_medium:utm_medium,
                utm_source:utm_source,
                cf_uvid:cf_uvid,
                generacion:generacion,
            }),
        });
        
        const responseJson = await response.json();

        // Show success / error response.
        document.getElementById('plans').hidden = true;
        document.getElementById('result').hidden = false;
       

        var message;
        var mensaje;
        if (responseJson.status === "succeeded" && selectedPlan !== undefined) {
            
            mensaje=`Gracias por tu compra, Pronto recibirás un correo electrónico desde 
                              soporte@fivetwofive.mx con tus accesos, 
                                Usted hizo un pago con este plan: ${
                selectedPlan.count
            } meses`;

            message = alertify.success(`<strong style="color:white;">¡Completo! Usted hizo un pago con este plan: ${
                selectedPlan.count
            } meses </strong>`);
            document.querySelector('#cont-summary').hidden=true;

        } else if (responseJson.status === "succeeded") {
            message = alertify.success('<strong style="color:white;">Completo! Pagaste en una sola exhibición!</strong>');
            mensaje=`Gracias por tu compra, Pronto recibirás un correo electrónico desde 
            soporte@fivetwofive.mx con tus accesos
            Usted hizo un pago en una sola exhibición`
            document.querySelector('#cont-summary').hidden=true;
            
        } else {
            if(responseJson.status === "Your card has expired."){
                btnconfim.hidden=false;
                btnloadingd.hidden=true;
                message =  alertify.error('<strong style="color: white;">Su tarjeta ha expirado. Por favor comunicate al Tel.5551043925</strong>');
                mensaje=`Error en la tarjeta`
                senderror(responseJson.status);
            }else if(responseJson.status === "Your card's security code is incorrect."){
                btnconfim.hidden=false;
                btnloadingd.hidden=true;
                message =  alertify.error('<strong style="color: white;">El código de seguridad de su tarjeta es incorrecto. Por favor comunicate al Tel.5551043925</strong>');
                mensaje=`Error en la tarjeta`
                senderror(responseJson.status);
            }else if(responseJson.status === "An error occurred while processing your card. Try again in a little bit."){
                btnconfim.hidden=false;
                btnloadingd.hidden=true;
                message =  alertify.error('<strong style="color: white;">Ha ocurrido un error al procesar su tarjeta. Intente de nuevo en unos momentos. Por favor comunicate al Tel.5551043925</strong>');
                mensaje=`Error en la tarjeta`
                senderror();
            }else if(responseJson.status === "Your card has insufficient funds."){
                btnconfim.hidden=false;
                btnloadingd.hidden=true;
                message =  alertify.error('<strong style="color: white;">Su tarjeta presenta fondos insuficientes. Por favor comunicate al Tel.5551043925</strong>');
                mensaje=`Error en la tarjeta`
                senderror(responseJson.status);
            }else if(responseJson.status === "Your card was declined."){
                btnconfim.hidden=false;
                btnloadingd.hidden=true;
                message =  alertify.error('<strong style="color: white;">Su tarjeta fue rechazada. Por favor comunicate al Tel.5551043925</strong>');
                mensaje=`Error en la tarjeta`
                senderror(responseJson.status);
            }else{
                message =  alertify.error('<strong style="color: white;">Su tarjeta fue rechazada. Por favor comunicate al Tel.5551043925</strong>');
                mensaje=`Error en la tarjeta`
                senderror(responseJson.status);
            }
        }

        document.getElementById("status-message").innerText = mensaje;

    });

    function reload(){
        location.reload();
    }
    
    
    //TODO: NEW CODE
    //USD
//    function checkboxChanged(checkbox) {
//     let checkboxes = document.querySelectorAll('input[name="currency"]');
    
//     checkboxes.forEach(function(currentCheckbox){
//         if(currentCheckbox !== checkbox){
//             currentCheckbox.checked = false;
//         }
//     });

//         if (checkbox.value == 'USD') {
//             // Consultar params
//             let productito = getparams().product;
//             if (productito == 'Incubadora de Libertad Financiera') {
//                 mount = '1100';
//             } else if (productito == 'Mentoría Veloz') {
//                 mount = '5999';
//             } else {
//                 mount = '310';//RI
//                 console.log(mount + "dolar");
//             }
//     } else {
//             let productito = getparams().product;
//             if (productito == 'Incubadora de Libertad Financiera') {
//                     mount = '16997';
//                 } else if (productito == 'Mentoría Veloz') {
//                     mount = '100000';
//             } else {
//                 mount = '4997';//RI
//                 console.log(mount + "peso");
//             }
//     }


//     document.querySelector('#mounth').innerText = maskDinero(mount);
// }
    
    
    
    
    
    function getparams(){
        const params = new URLSearchParams(location.search);
        const monto = params.get('mount');
        const ref = params.get('ref');
        const product = params.get('product');
        const plans = params.get('plans');
        const tags = params.get('tags');
        const utm_medium = params.get('utm_medium');
        const utm_source = params.get('utm_source');
        const generacion = params.get('generacion');
        const cf_uvid    = params.get('cf_uvid');
        const moneda    = params.get('moneda');
        if(monto==null||product==null||plans==null){
            document.getElementById('card-button').disabled=true;
            alertify.error('<strong style="color: white;">Necesario: Monto / Nombre del producto / Plan</strong>');
        }else{
            document.querySelector('#product-name').innerText=product;
            document.querySelector('#mounth').innerText=maskDinero(monto);
            
             // TODO: NEW CODE USD
            // if(product == 'Incubadora de Libertad Financiera USD' || "01 Riqueza Infinita" &&  moneda =='usd' ){
            //     let checkboxDolar = document.getElementById('product-selection');
            //     checkboxDolar.style.display = 'block'; 
            // }
             // TODO: NEW CODE      
        
            
            
        }
        return {
            monto: parseInt(monto),
            ref: ref,
            plan:plans,
            product:product,
            tags:tags,
            utm_medium:utm_medium,
            utm_source:utm_source,
            cf_uvid:cf_uvid,
            generacion:generacion,
        }
    }
    function senderror(mensaje){
        const name=document.getElementById('cardholder-name').value;
        const tel=document.getElementById('phone').value;
        const email=document.getElementById('email').value;
        fetch('https://hook.integromat.com/z8rw59v9858dkfehuqshsjlamu2f8r97', {
            method: 'POST',
            body: JSON.stringify({
                name:name,
                email:email,
                phone:tel,
                mensaje:mensaje
            })
        });
    }
    function descript(str){
        switch(str) {
        case '4e07408562bedb8b60ce05c1decfe3ad16b72230967de01f640b7e4729b49fce':
            return '3'
            break;
        case 'e7f6c011776e8db7cd330b54174fd76f7d0216b612387a5ffcfb81e6f0919683':
            return '6'
            break;
        case '19581e27de7ced00ff1ce50b2047e7a567c76b1cbaebabe5ef03f7c3017bb5b7':
            return '9'
            break;
        case '6b51d431df5d7f141cbececcf79edf3dd861c3b4069f0b11661a3eefacbba918':
            return '12'
            break;
        }
    }
    function maskDinero(numero) {
        return "$" + parseFloat(numero).toFixed(2).replace(/(\d)(?=(\d\d\d)+(?!\d))/g, "$1,")
    }
</script>
</html>
