<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\PagoController;
use App\Http\Controllers\Generaficha;
use App\Http\Controllers\Generaficha_Membresia;

Route::get('/', function () {
    return view('welcome');
});

// Route::post('/Plans', 'PagoController@store')->name('plans'); 
Route::post('/Plans', [PagoController::class, 'store'])->name('plans'); //update

Route::post('/ConfirmPlan', [PagoController::class, 'ConfirmPlan'])->name('confirm'); //update
// Route::post('/ConfirmPlan', 'PagoController@ConfirmPlan')->name('confirm'); 

Route::get('/ir-a-google', [PagoController::class, 'redirectToGoogle'])->name('ir_a_google');

Route::get('/css/my.style.css', function () {
    return response()->file(public_path('css/my.style.css'));
})->name('style.css');

Route::get('/js/alertify.js', function () {
    return response()->file(public_path('alertifyjs/alertify.js'));
})->name('alertify.js');

Route::get('/css/alertify.css', function () {
    return response()->file(public_path('alertifyjs/css/alertify.css'));
})->name('alertify.css');

Route::get('logo.png', function () {
    return response()->file(public_path('logo.png'));
})->name('logo.png');

Route::post('/generarFicha', [Generaficha::class, 'generarFicha']);

Route::post('/generarFichaMemb', [Generaficha_Membresia::class, 'generarFichaM']);